import os, random
import sys
sys.path.append(os.environ['HPDMFLEX'])
import pyHPDM.api as HPDM
import time 

class CallHPDM():
    def SetInputs(self):
        error : int = 0
        #os.chdir(self.data_path)  
        for HPInput in self.Inputs:
            error = error + self.HPDMapi.IN(HPInput)   
        #os.chdir(self.current_path)
        return error
    
    def RunAndOutputs(self):
        # this function will call the HPDM backend to calculate the desired total cooling, sensible cooling, and power consumption 
        os.chdir(self.data_path)  
        error : int = self.HPDMapi.RUN() 
        if(error == 0):
            for HPOutput in self.Outputs:
                self.HPDMapi.OUT(HPOutput)        
        os.chdir(self.current_path)
        return error
    
    def InitPath(self):
        self.current_path = os.getcwd() # energyplus temporary folder created by EnergyPlus
        os.chdir("..\..\HP_VRF_SC")        
        self.data_path = os.getcwd() #HPDM input data files     
        print ("hey initial path: ", os.getcwd())
        # time.sleep(500)
        #sys.("pause")
        os.chdir(self.current_path)
        #print ("final check path: ", os.getcwd())
        #print ("I am here")
        #time.sleep(500)

#custimized codes below ###############################################
class Curve_HPDM_IDMAP(CallHPDM):
    def __init__(self):    
        self.InitPath()
        
        #define HPDM instance, iputs and outputs
        self.str1 = "SystemConfig1.dat"
        self.iObjID = 0              
        self.iRunMode = 0
        self.iPrintFlg = 0
        self.iDebug = 0
        self.HPDMapi = HPDM.HPDMInstance(self.str1, self.iObjID, self.iRunMode, self.iPrintFlg, self.iDebug, isNewDLL = False)
        
        #inputs
        self.iCompID = 0   
        self.dRatCapacity=HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 0, 10000.0)
        self.RHI = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 1, 0.5) 
        self.INDT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 2, 80) 
        self.INDF = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 3, 400) 
        self.EVAPT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 4, 50) 
        self.LIQRT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 5, 100.0)  
        self.SUPGRADE = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 6, 2) 
        self.Inputs : HPDM.HPDMInput = {self.dRatCapacity, self.RHI, self.INDT, self.INDF, self.EVAPT, self.LIQRT, self.SUPGRADE}
        
        #outputs
        self.FANPOW = HPDM.HPDMOutput(self.iCompID, 11)
        self.TOTCAP = HPDM.HPDMOutput(self.iCompID, 12)
        self.SENCAP =HPDM.HPDMOutput(self.iCompID, 13)  
        self.MR =HPDM.HPDMOutput(self.iCompID, 14)        
        self.Outputs : HPDM.HPDMOutput ={self.FANPOW, self.TOTCAP, self.SENCAP, self.MR}
        
    
    def get_input_variables(self, cooling_cap_rated=10000, RelativeHum = 0.5, indoor_air_T = 80, Indoor_air_flow = 400, \
                            Evap_Temp=50, Liq_Temp=100, SuperH_Grad=2.0):

        self.dRatCapacity.Value=cooling_cap_rated
        self.RHI.Value = RelativeHum
        self.INDT.Value = indoor_air_T 
        self.INDF.Value = Indoor_air_flow 
        self.EVAPT.Value = Evap_Temp
        self.LIQRT.Value = Liq_Temp 
        self.SUPGRADE.Value = SuperH_Grad
        
        error : int = self.SetInputs()        
        return error
        

        
    def get_output_variable(self):
        error :int = self.RunAndOutputs()
                        
        print(self.FANPOW.Value)
        print(self.TOTCAP.Value)
        print(self.SENCAP.Value)
        print(self.MR.Value)
        #time.sleep(500)
                
        return (self.FANPOW.Value, self.TOTCAP.Value, self.SENCAP.Value, self.MR.Value)
 
class Curve_HPDM_ODMAP(CallHPDM):
    def __init__(self):    
        self.InitPath()
        
        #define HPDM instance, iputs and outputs
        self.str1 = "SystemConfig2.dat"
        self.iObjID = 1              
        self.iRunMode = 0
        self.iPrintFlg = 0
        self.iDebug = 0
        self.HPDMapi = HPDM.HPDMInstance(self.str1, self.iObjID, self.iRunMode, self.iPrintFlg, self.iDebug, isNewDLL = False)
        
        #inputs
        self.iCompID = 0   
        self.dRatCapacity=HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 0, 10000.0)
        self.MR = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 1, 200) 
        self.SUCSAT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 2, 80) 
        self.AMBT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 3, 400) 
        self.SUPERHEAT = HPDM.HPDMInput(self.iCompID, HPDM.NAt.V, 4, 50) 
        self.Inputs : HPDM.HPDMInput = {self.dRatCapacity, self.MR, self.SUCSAT, self.AMBT, self.SUPERHEAT}
        
        #outputs
        self.COMPPOW = HPDM.HPDMOutput(self.iCompID, 11)
        self.FANPOW = HPDM.HPDMOutput(self.iCompID, 12)
        self.COMPRPM =HPDM.HPDMOutput(self.iCompID, 13)  
        self.TOTCAP =HPDM.HPDMOutput(self.iCompID, 14)   
        self.LIQT =HPDM.HPDMOutput(self.iCompID, 15)         
        self.Outputs : HPDM.HPDMOutput ={self.COMPPOW, self.FANPOW, self.COMPRPM, self.TOTCAP,self.LIQT }
        
    
    def get_input_variables(self, cooling_cap_rated=10000, TotalMr = 200, Suction_Sat_T = 50.0, Ambient_T = 95, \
                            SuperheatDegreeR=10):

        self.dRatCapacity.Value=cooling_cap_rated
        self.MR.Value = TotalMr
        self.SUCSAT.Value = Suction_Sat_T 
        self.AMBT.Value = Ambient_T 
        self.SUPERHEAT.Value =  SuperheatDegreeR 
        
        #print(TotalMr, "    ", Suction_Sat_T, "    ", Ambient_T, "    ", SuperheatDegreeR)
        #time.sleep(5)
        
        error : int = self.SetInputs()        
        return error
        

        
    def get_output_variable(self):
        error :int = self.RunAndOutputs()
                        
        print(self.COMPPOW.Value)
        print(self.FANPOW.Value)
        print(self.COMPRPM.Value)
        print(self.TOTCAP.Value)
        print(self.LIQT.Value)
        #time.sleep(5)
                
        return (self.COMPPOW.Value, self.FANPOW.Value, self.COMPRPM.Value, self.TOTCAP.Value,self.LIQT.Value)